#! /bin/bash
export eclipseFolder=$(mdfind Eclipse.app | head -1 | sed "s/Eclipse\.app//")
export inStr=$(cat $(echo ${eclipseFolder}/configuration/.settings/org.eclipse.ui.ide.prefs) | grep RECENT_WORKSPACES=/ | sed -e "s/RECENT_WORKSPACES=//" -e 's,\\n,:,g'); 
export eclipseAlfredTemp="$TMPDIR/alfred"
OIFS=$IFS; 
IFS=':'; 
arr=$inStr; 
echo "<?xml version=\"1.0\">" > $eclipseAlfredTemp; 
echo "<items>" > $eclipseAlfredTemp;
QUERY="$1"
unset QUERY_FUZZY
for (( i=0; i<${#QUERY}; i++)); do
	QUERY_FUZZY+="${QUERY:$i:1}.*"
done

if [[ $(echo $QUERY_FUZZY) == "" ]]; then
	echo "<item uuid=\"$(uuidgen)\" arg=\"${eclipseFolder}/Eclipse.app/Contents/MacOS/eclipse\" valid=\"YES\" type=\"file\">" >> $eclipseAlfredTemp
	echo "<title>Open Eclipse - Default</title>" >> $eclipseAlfredTemp; 
	echo "<subtitle>Open Eclipse using Default Workspace</subtitle>" >> $eclipseAlfredTemp; 
	echo "</item>"  >> $eclipseAlfredTemp; 
fi

unset USED_WORKSPACE
for workspace in $arr; do 
	WORKSPACE_NAME=$(echo $workspace | sed 's,.*/,,g')
	if [ $(echo $WORKSPACE_NAME | grep -o "$QUERY") ] && [[ $(echo $USED_WORKSPACE | grep -o "${workspace}") == "" ]]; then
		USED_WORKSPACE+=$workspace
		echo "<item uuid=\"$(uuidgen)\" arg=\"${eclipseFolder}/Eclipse.app/Contents/MacOS/eclipse -data $workspace -name $WORKSPACE_NAME\" valid=\"YES\" type=\"file\">" >> $eclipseAlfredTemp
		echo "<title>Open Eclipse - $WORKSPACE_NAME</title>" >> $eclipseAlfredTemp
		echo "<subtitle>Open Eclipse using Workspace: $workspace</subtitle>" >> $eclipseAlfredTemp; 
		echo '</item>' >> $eclipseAlfredTemp
	fi
done; 

for workspace in $arr; do 
	WORKSPACE_NAME=$(echo $workspace | sed 's,.*/,,g')
	if [ $(echo $workspace | grep -o "$QUERY") ] && [[ $(echo $USED_WORKSPACE | grep -o "${workspace}") == "" ]]; then
		USED_WORKSPACE+=$workspace
		echo "<item uuid=\"$(uuidgen)\" arg=\"${eclipseFolder}/Eclipse.app/Contents/MacOS/eclipse -data $workspace -name $WORKSPACE_NAME\" valid=\"YES\" type=\"file\">" >> $eclipseAlfredTemp
		echo "<title>Open Eclipse - $WORKSPACE_NAME</title>" >> $eclipseAlfredTemp
		echo "<subtitle>Open Eclipse using Workspace: $workspace</subtitle>" >> $eclipseAlfredTemp; 
		echo '</item>' >> $eclipseAlfredTemp
	fi
done; 

for workspace in $arr; do 
	WORKSPACE_NAME=$(echo $workspace | sed 's,.*/,,g')
	if [ $(echo $WORKSPACE_NAME | grep -o "$QUERY_FUZZY") ] && [[ $(echo $USED_WORKSPACE | grep -o "${workspace}") == "" ]]; then
		USED_WORKSPACE+=$workspace
		echo "<item uuid=\"$(uuidgen)\" arg=\"${eclipseFolder}/Eclipse.app/Contents/MacOS/eclipse -data $workspace -name $WORKSPACE_NAME\" valid=\"YES\" type=\"file\">" >> $eclipseAlfredTemp
		echo "<title>Open Eclipse - $WORKSPACE_NAME</title>" >> $eclipseAlfredTemp
		echo "<subtitle>Open Eclipse using Workspace: $workspace</subtitle>" >> $eclipseAlfredTemp; 
		echo '</item>' >> $eclipseAlfredTemp
	fi
done; 

for workspace in $arr; do 
	if [ $(echo $workspace | grep -o "$QUERY_FUZZY") ] && [[ $(echo $USED_WORKSPACE | grep -o "${workspace}") == "" ]]; then
		USED_WORKSPACE+=$workspace
		WORKSPACE_NAME=$(echo $workspace | sed 's,.*/,,g')
		echo "<item uuid=\"$(uuidgen)\" arg=\"${eclipseFolder}/Eclipse.app/Contents/MacOS/eclipse -data $workspace -name $WORKSPACE_NAME\" valid=\"YES\" type=\"file\">" >> $eclipseAlfredTemp
		echo "<title>Open Eclipse - $WORKSPACE_NAME</title>" >> $eclipseAlfredTemp
		echo "<subtitle>Open Eclipse using Workspace: $workspace</subtitle>" >> $eclipseAlfredTemp; 
		echo '</item>' >> $eclipseAlfredTemp
	fi
done; 

if [[ $(echo $QUERY_FUZZY) != "" ]]; then
	echo "<item uuid=\"$(uuidgen)\" arg=\"${eclipseFolder}/Eclipse.app/Contents/MacOS/eclipse\" valid=\"YES\" type=\"file\">" >> $eclipseAlfredTemp
	echo "<title>Open Eclipse - Default</title>" >> $eclipseAlfredTemp; 
	echo "<subtitle>Open Eclipse using Default Workspace</subtitle>" >> $eclipseAlfredTemp; 
	echo "</item>"  >> $eclipseAlfredTemp; 
fi

echo '</items>' >> $eclipseAlfredTemp
cat $eclipseAlfredTemp
IFS=$OIFS;